#ifndef IOS_BRIDGE_H
#define IOS_BRIDGE_H

#ifdef __cplusplus
extern "C" {
#endif

// エンジンハンドル（不透明ポインタ）
typedef void* YaneuraOuEngineHandle;

// エンジンを作成
YaneuraOuEngineHandle yaneuraou_engine_create(void);

// エンジンを破棄
void yaneuraou_engine_destroy(YaneuraOuEngineHandle handle);

// USIコマンドを送信
int yaneuraou_engine_send_command(YaneuraOuEngineHandle handle, const char* command);

// エンジンからの応答を受信（タイムアウト付き）
// 戻り値: 応答文字列（呼び出し側でfreeする必要あり）、タイムアウトまたはエラーの場合はNULL
char* yaneuraou_engine_receive_response(YaneuraOuEngineHandle handle, double timeout_seconds);

// エンジンが準備完了かチェック
int yaneuraou_engine_is_ready(YaneuraOuEngineHandle handle);

#ifdef __cplusplus
}
#endif

#endif // IOS_BRIDGE_H
