#!/bin/bash
set -e
set -x

# arm64シミュレータ用のビルド
cmake -Sios_arm64_sim -G Xcode ./ios_arm64_sim -B bin/ios_arm64_sim -DPLATFORM=SIMULATORARM64 -DDEPLOYMENT_TARGET=16.0 -DCMAKE_TOOLCHAIN_FILE=ios.toolchain.cmake
cmake --build ./bin/ios_arm64_sim --config Release || true

# ビルドエラーを無視してフレームワークが作成されているか確認
if [ ! -d "bin/ios_arm64_sim/Release-iphonesimulator/yaneuraou.framework" ]; then
    echo "Error: Simulator framework not created"
    exit 1
fi

# フレームワークのクリーンアップ（メタデータ削除）
find bin/ios_arm64_sim/Release-iphonesimulator/yaneuraou.framework -name ".DS_Store" -delete 2>/dev/null || true
find bin/ios_arm64_sim/Release-iphonesimulator/yaneuraou.framework -name "._*" -delete 2>/dev/null || true
xattr -cr bin/ios_arm64_sim/Release-iphonesimulator/yaneuraou.framework 2>/dev/null || true

# arm64実機用のビルド
cmake -Sios_arm64 -G Xcode ./ios_arm64 -B bin/ios_arm64 -DPLATFORM=OS64 -DDEPLOYMENT_TARGET=16.0 -DCMAKE_TOOLCHAIN_FILE=ios.toolchain.cmake
cmake --build ./bin/ios_arm64 --config Release || true

# ビルドエラーを無視してフレームワークが作成されているか確認
if [ ! -d "bin/ios_arm64/Release-iphoneos/yaneuraou.framework" ]; then
    echo "Error: Device framework not created"
    exit 1
fi

# フレームワークのクリーンアップ（メタデータ削除）
find bin/ios_arm64/Release-iphoneos/yaneuraou.framework -name ".DS_Store" -delete 2>/dev/null || true
find bin/ios_arm64/Release-iphoneos/yaneuraou.framework -name "._*" -delete 2>/dev/null || true
xattr -cr bin/ios_arm64/Release-iphoneos/yaneuraou.framework 2>/dev/null || true

# XCFrameworkの作成（arm64実機とarm64シミュレータのみ）
# ダイナミックフレームワークとして作成
rm -rf ../Frameworks/libyaneuraou.xcframework
xcodebuild -create-xcframework \
    -framework bin/ios_arm64/Release-iphoneos/yaneuraou.framework \
    -framework bin/ios_arm64_sim/Release-iphonesimulator/yaneuraou.framework \
    -output ../Frameworks/libyaneuraou.xcframework
