#!/bin/bash
set -e
set -x

# arm64シミュレータ用のビルド
cmake -Sios_arm64_sim -G Xcode ./ios_arm64_sim -B bin/ios_arm64_sim -DPLATFORM=SIMULATORARM64 -DCMAKE_TOOLCHAIN_FILE=ios.toolchain.cmake
cmake --build ./bin/ios_arm64_sim --config Release

# arm64実機用のビルド
cmake -Sios_arm64 -G Xcode ./ios_arm64 -B bin/ios_arm64 -DPLATFORM=OS64 -DCMAKE_TOOLCHAIN_FILE=ios.toolchain.cmake
cmake --build ./bin/ios_arm64 --config Release

# XCFrameworkの作成（arm64のみ）
# ダイナミックフレームワークとして作成
rm -rf ../Frameworks/libyaneuraou.xcframework
xcodebuild -create-xcframework \
    -framework bin/ios_arm64/Release-iphoneos/yaneuraou.framework \
    -framework bin/ios_arm64_sim/Release-iphonesimulator/yaneuraou.framework \
    -output ../Frameworks/libyaneuraou.xcframework
