# やねうら王 パフォーマンス最適化ガイド

## 最適化内容

### 1. コンパイラ最適化フラグの追加

以下の最適化フラグを追加しました：

- `-flto`: Link Time Optimization（リンク時最適化）
- `-funroll-loops`: ループ展開による高速化
- `-fomit-frame-pointer`: フレームポインタ省略によるレジスタ使用効率向上
- `-DFV_SCALE=16`: 評価値スケーリング係数の明示的設定

### 2. 実機とシミュレータの違い

- **シミュレータ**: `-O3` + 最適化フラグ
- **実機**: `-Ofast` + `-DUSE_NEON` + 最適化フラグ

実機では ARM NEON 命令が有効化されており、大幅に高速です。

## リビルド手順

### 1. ビルドディレクトリのクリーン

```bash
cd YaneuraOuiOSSPM-build/build
rm -rf bin/
```

### 2. リビルド実行

```bash
./build_arm64_sim.bash
```

このスクリプトは以下を実行します：
1. ARM64シミュレータ用ビルド
2. ARM64実機用ビルド
3. XCFrameworkの作成

### 3. Xcodeプロジェクトのクリーン

Xcodeで：
1. Product > Clean Build Folder (⇧⌘K)
2. プロジェクトを再ビルド

## 期待される改善

### パフォーマンス向上の目安

- **LTO (-flto)**: 5-15% の高速化
- **ループ展開 (-funroll-loops)**: 3-10% の高速化
- **フレームポインタ省略**: 2-5% の高速化
- **合計**: 10-30% の高速化が期待できます

### 実機 vs シミュレータ

- シミュレータ: 約 50-100 kNPS (千ノード/秒)
- 実機 (iPhone 12以降): 約 200-500 kNPS
- 実機は **2-5倍** 高速です

## 追加の最適化オプション

### より軽量な評価関数

現在: `EVAL_NNUE_KP256`

より高速だが精度が若干低下する選択肢：
```cmake
-DEVAL_NNUE_HALFKP_256X2_32_32
```

### エンジン設定の調整

`EngineCoordinator.swift` で設定可能：

```swift
// スレッド数（デフォルト: 4）
try bridge?.sendCommand("setoption name Threads value 2")

// ハッシュサイズ（デフォルト: 1000MB）
try bridge?.sendCommand("setoption name USI_Hash value 512")
```

メモリを削減してスレッド数を減らすと、モバイルデバイスでより安定します。

## ベンチマーク方法

### NPS（Nodes Per Second）の確認

解析中のログで確認できます：
```
📊 [AnalysisService] 進捗更新: ... - NPS: 150000
```

### 改善前後の比較

1. 改善前のNPSを記録
2. リビルド実行
3. 同じ局面で解析してNPSを比較

## トラブルシューティング

### ビルドエラーが発生する場合

1. `-flto` を削除してみる（一部の環境で問題が起きる場合があります）
2. Xcodeのバージョンを確認（14.0以降推奨）

### パフォーマンスが改善しない場合

1. 実機でテストする（シミュレータは遅い）
2. デバッグビルドではなくReleaseビルドを使用
3. バックグラウンドアプリを終了してメモリを確保

## 参考情報

- やねうら王公式: https://github.com/yaneurao/YaneuraOu
- NNUE評価関数: https://github.com/ynasu87/nnue-pytorch
