# やねうら王エンジンのセットアップ手順

## 概要

このドキュメントでは、やねうら王エンジンをSwiftUIShogiアプリに統合する手順を説明します。

## 重要な注意事項

⚠️ **やねうら王のバージョン**: このプロジェクトでは**v8.60git**を使用します。
- ✅ v8.60git: 評価値が正確に出力される
- ❌ V9.00以降: 評価値が正しく出ないため使用しない

## 必要なファイル

### 1. やねうら王エンジンバイナリ（v8.60git）

**macOS用バイナリのダウンロード:**

1. [やねうら王リリースページ](https://github.com/yaneurao/YaneuraOu/releases)にアクセス
2. v8.60gitリリースから`YaneuraOu-*-macos.zip`をダウンロード
3. 解凍して`YaneuraOu-by-clang`（またはgcc版）を取得

**または、ソースからビルド:**

```bash
# やねうら王をクローン
git clone https://github.com/yaneurao/YaneuraOu.git
cd YaneuraOu

# v8.60gitにチェックアウト
git checkout v8.60git

cd source

# macOS用にビルド（NNUE評価関数対応、halfKP256形式）
make tournament YANEURAOU_EDITION=YANEURAOU_ENGINE_NNUE
```

### 2. 評価関数ファイル（halfKP256形式）

**重要**: v8.60gitではhalfKP256形式（EVAL_NNUE_HALFKP256）の評価関数を使用します。

**水匠5評価関数（推奨）:**
```bash
# 水匠5評価関数（約61MB、halfKP256形式）
# 詳細はREADME_SUISHO5.mdを参照
```

**または軽量版:**
```bash
# halfKP256形式の軽量評価関数
# v8.60git対応のnn.binファイルを使用
```

水匠5の詳細なセットアップ手順は、README_SUISHO5.mdを参照してください。

## セットアップ手順

### ステップ1: バイナリの配置

```bash
# プロジェクトルートから実行
cd EngineModule

# バイナリを配置
cp /path/to/YaneuraOu-by-clang Resources/bin/
chmod +x Resources/bin/YaneuraOu-by-clang

# 評価関数を配置
cp /path/to/nn-xxxxxxxx.bin Resources/eval/nn.bin
```

### ステップ2: Package.swiftの更新

`EngineModule/Package.swift`を編集して、リソースを追加します。

### ステップ3: 動作確認

```bash
# エンジンが動作するか確認
./Resources/bin/YaneuraOu-by-clang

# USIコマンドを送信
echo "usi" | ./Resources/bin/YaneuraOu-by-clang
```

正常に動作すれば、`id name YaneuraOu`などの応答が返ってきます。

## 次のステップ

1. EngineCoordinatorでバイナリパスを設定
2. 評価関数の読み込み設定
3. USIプロトコルでの通信テスト
4. 解析機能の統合

## トラブルシューティング

### エラー: "Permission denied"

```bash
chmod +x Resources/bin/YaneuraOu-by-clang
```

### エラー: "dyld: Library not loaded"

macOSのセキュリティ設定で実行を許可する必要があります：
1. システム環境設定 > セキュリティとプライバシー
2. 「このまま許可」をクリック

### エラー: "Evaluation file not found"

評価関数ファイルが正しく配置されているか確認してください。

## バージョン情報

- **推奨バージョン**: やねうら王 v8.60git
- **評価関数形式**: halfKP256 (EVAL_NNUE_HALFKP256)
- **注意**: V9.00以降は評価値が正しく出ないため使用しない

## 参考リンク

- [やねうら王公式リポジトリ](https://github.com/yaneurao/YaneuraOu)
- [やねうら王 v8.60git](https://github.com/yaneurao/YaneuraOu/tree/v8.60git)
- [USIプロトコル仕様](http://shogidokoro.starfree.jp/usi.html)
- `VERSION_NOTICE.md` - バージョンに関する重要な注意事項
- `README_SUISHO5.md` - 水匠5セットアップガイド
