# 水匠5モデルへのアップグレード手順

## 概要

このドキュメントは、軽量モデルから水匠5評価関数へのアップグレード手順を説明します。

## 重要な注意事項

⚠️ **やねうら王のバージョン**: このプロジェクトでは**v8.60git**を使用します。
- ✅ v8.60git: 評価値が正確に出力される
- ❌ V9.00以降: 評価値が正しく出ないため使用しない

## 必要なファイル

### 1. やねうら王エンジンバイナリ

- **バージョン**: v8.60git（必須）
- **ファイル名**: `YaneuraOu-by-gcc`（またはプラットフォーム固有のバイナリ）
- **入手先**: [やねうら王公式リポジトリ](https://github.com/yaneurao/YaneuraOu)
- **ビルド方法**: 
  ```bash
  cd YaneuraOu
  git checkout v8.60git
  cd source
  make tournament
  ```

### 2. 水匠5評価関数ファイル

- **ファイル名**: `nn.bin`
- **サイズ**: 約61MB
- **形式**: halfKP256 (EVAL_NNUE_HALFKP256)
- **入手先**: [水匠公式サイト](https://github.com/mizar/YaneuraOu)
- **配置場所**: `EngineModule/Resources/eval/`

## アップグレード手順

### ステップ1: 評価関数ファイルの配置

1. 水匠5の評価関数ファイル（`nn.bin`）をダウンロード
2. プロジェクトに追加:
   ```
   EngineModule/
   └── Resources/
       └── eval/
           └── nn.bin
   ```

### ステップ2: Package.swiftの更新

`EngineModule/Package.swift`を編集して、リソースを追加:

```swift
.target(
    name: "EngineModule",
    dependencies: [],
    resources: [
        .copy("Resources/eval/nn.bin")
    ]
)
```

### ステップ3: エンジン初期化の更新

`EngineCoordinator.swift`で評価関数のパスを指定:

```swift
func initialize() async throws {
    // 評価関数ファイルのパスを取得
    guard let evalPath = Bundle.module.path(forResource: "nn", ofType: "bin", inDirectory: "Resources/eval") else {
        throw EngineError.evaluationFileNotFound
    }
    
    // エンジンに評価関数を設定
    try await sendCommand("setoption name EvalDir value \(evalPath)")
    try await sendCommand("isready")
    
    // readyokを待つ
    // ...
}
```

### ステップ4: バンドルサイズの確認

水匠5の評価関数ファイルは約250MBあるため、アプリのバンドルサイズが大きくなります。

**対策オプション:**

1. **オンデマンドダウンロード**: 初回起動時にダウンロード
2. **軽量版の使用**: 初期は軽量モデル、必要に応じてアップグレード
3. **App Thinning**: iOSのApp Thinningを活用

### ステップ5: ダウンロード機能の実装（オプション）

バンドルサイズを抑えるため、オンデマンドダウンロードを実装:

```swift
class ModelDownloader {
    func downloadSuisho5() async throws {
        let url = URL(string: "https://example.com/suisho5/nn.bin")!
        let (localURL, _) = try await URLSession.shared.download(from: url)
        
        // ダウンロードしたファイルをドキュメントディレクトリに移動
        let documentsPath = FileManager.default.urls(for: .documentDirectory, in: .userDomainMask)[0]
        let destinationURL = documentsPath.appendingPathComponent("eval/nn.bin")
        
        try FileManager.default.moveItem(at: localURL, to: destinationURL)
    }
}
```

## パフォーマンステスト

水匠5モデルに切り替えた後、以下をテスト:

1. **解析速度**: 1局面あたり1秒で解析できるか
2. **メモリ使用量**: 200MB以下に収まるか
3. **バッテリー消費**: 長時間解析時のバッテリー消費

## トラブルシューティング

### エラー: "Evaluation file not found"

- 評価関数ファイルが正しく配置されているか確認
- Bundle.moduleのパスが正しいか確認

### エラー: "Engine initialization failed"

- やねうら王バイナリが正しくビルドされているか確認
- 実行権限が付与されているか確認

### パフォーマンスが遅い

- スレッド数を調整: `setoption name Threads value 2`
- ハッシュサイズを調整: `setoption name USI_Hash value 256`

## 参考リンク

- [やねうら王公式リポジトリ](https://github.com/yaneurao/YaneuraOu)
- [やねうら王 v8.60git](https://github.com/yaneurao/YaneuraOu/tree/v8.60git)
- [水匠公式サイト](https://github.com/mizar/YaneuraOu)
- [USIプロトコル仕様](http://shogidokoro.starfree.jp/usi.html)

## バージョン情報

- **推奨バージョン**: やねうら王 v8.60git
- **評価関数形式**: halfKP256 (EVAL_NNUE_HALFKP256)
- **注意**: V9.00以降は評価値が正しく出ないため使用しない
