# EngineModule

GPL3ライセンスの将棋エンジン統合モジュール

## 概要

このモジュールは、やねうら王将棋エンジンをiOSアプリケーションに統合するためのラッパーです。GPL3ライセンスのコンプライアンスを維持するため、プロプライエタリなメインアプリケーションから分離されています。

## ライセンス

このモジュールはGPL v3ライセンスの下で提供されています。やねうら王エンジンの派生物として、GPL v3の要件に従います。

## 使用方法

メインアプリケーションは、`EngineInterface`プロトコルを通じてこのモジュールと通信します。プロトコル境界により、メインアプリケーションはGPL3ライセンスの影響を受けません。

```swift
import EngineModule

let engine: EngineInterface = EngineCoordinator()
try await engine.initialize(modelPath: "path/to/model")
let evaluation = try await engine.analyzePosition(sfen: "position sfen ...", timeLimit: 1.0)
```

## 依存関係

- YaneuraOu iOS SPM: https://github.com/select766/YaneuraOuiOSSPM
