// swift-tools-version: 5.9
import PackageDescription

let package = Package(
    name: "EngineModule",
    platforms: [
        .iOS(.v16),
        .macOS(.v12)
    ],
    products: [
        .library(
            name: "EngineModule",
            targets: ["EngineModule"]),
    ],
    dependencies: [
        // YaneuraOu - ローカルXCFrameworkを使用
        // 注意: YaneuraOuiOSSPMパッケージはarm64シミュレータをサポートしていないため、
        // ローカルビルドのXCFrameworkを使用します
    ],
    targets: [
        .binaryTarget(
            name: "libyaneuraou",
            path: "Resources/libyaneuraou.xcframework"
        ),
        .target(
            name: "CYaneuraOu",
            dependencies: ["libyaneuraou"],
            publicHeadersPath: "include"
        ),
        .target(
            name: "EngineModule",
            dependencies: ["CYaneuraOu"],
            linkerSettings: [
                .linkedLibrary("c++"),
                .linkedLibrary("stdc++")
            ]),
        .testTarget(
            name: "EngineModuleTests",
            dependencies: ["EngineModule"])
    ]
)
