# やねうら王 iOS統合 - GPL v3 ソースコード配布パッケージ (v2.0)

## 概要

このパッケージには、やねうら王（GPL v3）を使用したiOS将棋アプリのエンジン部分のソースコードが含まれています。

v2.0の主な変更点: スタティックリンク（`.a`）からダイナミックリンク（`.framework`）に変更しました。

## ライセンス

このパッケージに含まれるすべてのコードはGPL v3でライセンスされています。

- やねうら王: GPL v3
- EngineModule: GPL v3（やねうら王の派生物として）
- iOS統合コード: GPL v3

詳細は`LICENSE.txt`を参照してください。

## パッケージ内容

```
GPL/
├── README.md                    # このファイル
├── LICENSE.txt                  # GPL v3ライセンス全文
├── BUILD_INSTRUCTIONS.md        # ビルド手順
├── EXTERNAL_RESOURCES.md        # 外部リソースの入手方法
└── code/                        # ソースコード
    ├── EngineModule/            # Swift Package Manager モジュール
    │   ├── Sources/
    │   │   ├── CYaneuraOu/     # Cラッパー
    │   │   └── EngineModule/   # Swift実装
    │   ├── Resources/
    │   │   ├── bin/            # 空ディレクトリ
    │   │   └── eval/           # 評価関数ファイル配置先（別途入手）
    │   ├── Tests/
    │   ├── Package.swift
    │   └── LICENSE
    └── YaneuraOuiOSSPM-build/   # iOS用ビルド環境
        └── build/
            ├── src/             # iOS統合コード
            ├── include/         # ヘッダーファイル
            ├── ios_arm64/       # 実機用ビルド設定
            ├── ios_arm64_sim/   # シミュレータ用ビルド設定
            └── build_arm64_sim.bash  # ビルドスクリプト
```

注意: 容量の都合上、以下は含まれていません：
- やねうら王本体のソースコード（GitHubから入手）
- ビルド済みバイナリ（ご自身でビルド）
- 評価関数ファイル（別途入手）

詳細は`EXTERNAL_RESOURCES.md`を参照してください。

## v2.0の変更点

### ダイナミックリンクへの移行

従来のスタティックライブラリ（`.a`）から、ダイナミックライブラリ（`.framework`）に変更しました。


## やねうら王について

- バージョン: v8.60git
- 公式リポジトリ: https://github.com/yaneurao/YaneuraOu
- ライセンス: GPL v3
- 作者: やねうらお氏

## 使用方法

### 1. やねうら王のソースコードを取得

```bash
git clone --branch v8.60git https://github.com/yaneurao/YaneuraOu.git
```

### 2. ビルド

詳細は`BUILD_INSTRUCTIONS.md`を参照してください。

### 3. アプリへの統合

`EngineModule`をSwift Package Managerで統合します。

```swift
// Package.swift
dependencies: [
    .package(path: "./EngineModule")
]
```

## ビルドについて

このパッケージには、ビルド済みバイナリは含まれていません。

ビルド手順に従って、ダイナミックライブラリ（`.framework`）形式でビルドしてください。

- 形式: ダイナミックライブラリ（`.framework`）
- 対応: arm64実機 + arm64シミュレータ
- iOS: 16.0以降

詳細は`BUILD_INSTRUCTIONS.md`を参照してください。

## 評価関数ファイルについて

評価関数ファイル（nn.bin）は含まれていません。

評価関数ファイルは別ライセンスのため、以下から入手してください：

- 水匠5: https://github.com/mizar/YaneuraOu/releases
- その他の評価関数: やねうら王のリリースページ

## 技術的な詳細

### アーキテクチャ

```
iOS App (独自ライセンス)
    ↓ USIプロトコル（ソケット通信）
EngineModule (GPL v3)
    ↓ C API
libyaneuraou.xcframework (GPL v3) ← ダイナミックライブラリ
    ↓
やねうら王 v8.60git (GPL v3)
```

### リンク方式

v1.0（旧版）: スタティックリンク
```
アプリ ← 静的にリンク ← libyaneuraou.a
```

v2.0（新版）: ダイナミックリンク
```
アプリ ← 実行時リンク ← yaneuraou.framework
```

## GPL v3 コンプライアンス

### このパッケージで提供されるもの

✅ EngineModuleの完全なソースコード
✅ iOS統合コード（ios_main.cpp等）
✅ ビルドスクリプトとCMakeLists.txt
✅ ビルド手順のドキュメント
✅ ビルド済みバイナリ（ダイナミックライブラリ）

### 提供されないもの

❌ やねうら王本体のソースコード（公式リポジトリから入手）
❌ 評価関数ファイル（別ライセンス）
❌ アプリ本体のコード（独自ライセンス）

## サポート

### やねうら王に関する質問

公式リポジトリのIssuesを参照してください：
https://github.com/yaneurao/YaneuraOu/issues

### iOS統合に関する質問

このパッケージに関する質問は、配布元にお問い合わせください。

## 変更履歴

### v2.0.0 (2025年11月28日)

- 重要: スタティックリンクからダイナミックリンクに変更
- CMakeLists.txtを更新（SHARED ライブラリ化）
- ビルドスクリプトを更新（.framework形式）
- シンボルの可視性設定を変更

### v1.0.0 (2025年11月11日)

- 初回リリース
- やねうら王 v8.60git を使用
- iOS 16.0以降に対応
- halfKP256評価関数形式に対応

## ライセンス表示

このソフトウェアは、やねうら王（GPL v3）を使用しています。

```
YaneuraOu
Copyright (C) やねうらお
Licensed under GPL v3
https://github.com/yaneurao/YaneuraOu

EngineModule (iOS Integration)
Copyright (C) 2025
Licensed under GPL v3 (as derivative work of YaneuraOu)
```

GPL v3の全文は`LICENSE.txt`を参照してください。

## 謝辞

- やねうらお氏 - やねうら王の開発
- 水匠開発チーム - 高精度な評価関数の提供
- select766氏 - YaneuraOuiOSSPMの開発

---

きふみAI  
最終更新: 2025年11月28日
