# ビルド手順

## 概要

やねうら王v8.60gitをiOS向けにダイナミックライブラリとしてビルドする手順を説明します。

v2.0の変更点: スタティックライブラリ（`.a`）からダイナミックライブラリ（`.framework`）に変更しました。

## 前提条件

### 必要な環境

- macOS: 最新版推奨
- Xcode: 14.0以降
- CMake: 3.15以降

### CMakeのインストール

```bash
brew install cmake
export PATH="/opt/homebrew/bin:$PATH"
```

## ステップ1: やねうら王のソースコードを取得

```bash
cd code/YaneuraOuiOSSPM-build

# やねうら王v8.60gitをクローン
git clone --branch v8.60git https://github.com/yaneurao/YaneuraOu.git

# バージョン確認
cd YaneuraOu
git describe --tags  # 出力: v8.60git
cd ..
```

## ステップ2: ビルド実行

### 自動ビルド（推奨）

```bash
cd build
export PATH="/opt/homebrew/bin:$PATH"

# arm64実機 + arm64シミュレータをビルドしてXCFrameworkを作成
bash build_arm64_sim.bash
```

### 手動ビルド

#### シミュレータ用

```bash
cd build

# CMake設定
cmake -G Xcode \
    -B bin/ios_arm64_sim \
    -S ios_arm64_sim \
    -DPLATFORM=SIMULATORARM64 \
    -DDEPLOYMENT_TARGET=16.0 \
    -DCMAKE_TOOLCHAIN_FILE=$(pwd)/ios_arm64_sim/ios.toolchain.cmake

# ビルド
cmake --build bin/ios_arm64_sim --config Release || true
```

#### 実機用

```bash
# CMake設定
cmake -G Xcode \
    -B bin/ios_arm64 \
    -S ios_arm64 \
    -DPLATFORM=OS64 \
    -DDEPLOYMENT_TARGET=16.0 \
    -DCMAKE_TOOLCHAIN_FILE=$(pwd)/ios_arm64/ios.toolchain.cmake

# ビルド
cmake --build bin/ios_arm64 --config Release || true
```

#### XCFrameworkの作成

```bash
# メタデータのクリーンアップ
find bin/ios_arm64_sim/Release-iphonesimulator/yaneuraou.framework -name ".DS_Store" -delete
find bin/ios_arm64/Release-iphoneos/yaneuraou.framework -name ".DS_Store" -delete
xattr -cr bin/ios_arm64_sim/Release-iphonesimulator/yaneuraou.framework
xattr -cr bin/ios_arm64/Release-iphoneos/yaneuraou.framework

# XCFramework作成
rm -rf ../Frameworks/libyaneuraou.xcframework
xcodebuild -create-xcframework \
    -framework bin/ios_arm64/Release-iphoneos/yaneuraou.framework \
    -framework bin/ios_arm64_sim/Release-iphonesimulator/yaneuraou.framework \
    -output ../Frameworks/libyaneuraou.xcframework
```

## ステップ3: ダイナミックライブラリの確認

```bash
# ライブラリ形式の確認
file ../Frameworks/libyaneuraou.xcframework/ios-arm64/yaneuraou.framework/yaneuraou

# 期待される出力:
# Mach-O 64-bit dynamically linked shared library arm64

# シンボルのエクスポート確認
nm -g ../Frameworks/libyaneuraou.xcframework/ios-arm64-simulator/yaneuraou.framework/yaneuraou | grep yaneuraou_ios

# 期待される出力:
# 0000000000099644 T _yaneuraou_ios_server_start
# 0000000000099af4 T _yaneuraou_ios_server_stop
```

## ステップ4: EngineModuleへの統合

```bash
cd ../../..

# XCFrameworkをコピー
cp -r code/YaneuraOuiOSSPM-build/Frameworks/libyaneuraou.xcframework \
      code/EngineModule/Resources/
```

## ステップ5: ビルドの確認

```bash
cd code/EngineModule
swift build
```

## v2.0の主な変更点

### CMakeLists.txt

変更前（スタティックライブラリ）:
```cmake
add_library(yaneuraou STATIC ${SRC})
```

変更後（ダイナミックライブラリ）:
```cmake
add_library(yaneuraou SHARED ${SRC})

set_target_properties(yaneuraou PROPERTIES
    FRAMEWORK TRUE
    FRAMEWORK_VERSION A
    MACOSX_FRAMEWORK_IDENTIFIER com.yaneuraou.engine
    VERSION 1.0.0
    SOVERSION 1.0.0
    PUBLIC_HEADER "../include/yaneuraou_if.h"
)
```

### シンボルの可視性

変更前:
```cmake
-fvisibility=hidden
-fvisibility-inlines-hidden
```

変更後:
```cmake
-fvisibility=default
```

### リンカーオプション

変更前:
```cmake
-Wl,-gc-sections
-Wl,-strip-all
```

変更後:
```cmake
# ダイナミックライブラリでは使用不可のため削除
```

## トラブルシューティング

### コードサインエラー

ビルドスクリプトで`|| true`を使用してエラーを無視し、後でクリーンアップしています。

### シンボルが見つからない

`-fvisibility=default`が設定されているか確認してください。

```bash
grep "fvisibility" build/ios_arm64/CMakeLists.txt
```

## 評価関数ファイルの配置

### 水匠5評価関数の取得

1. https://github.com/mizar/YaneuraOu/releases から`nn.bin`をダウンロード
2. `code/EngineModule/Resources/eval/`に配置

```bash
mkdir -p code/EngineModule/Resources/eval
cp /path/to/nn.bin code/EngineModule/Resources/eval/
```

## 参考情報

### ビルド成果物

- yaneuraou.framework: 約2.5MB（ダイナミックライブラリ）
- libyaneuraou.xcframework: 約5MB

### 含まれる機能

- ✅ NNUE評価関数（halfKP256形式）
- ✅ USIプロトコル
- ✅ MultiPV（複数候補手）
- ✅ 詰み探索

### 外部リソース

- やねうら王: https://github.com/yaneurao/YaneuraOu
- 水匠5評価関数: https://github.com/mizar/YaneuraOu/releases
- iOS Toolchain: https://github.com/leetal/ios-cmake

---

きふみAI  
最終更新: 2025年11月28日
